document.getElementById("calc").addEventListener("click", async () => {
    let [tab] = await chrome.tabs.query({ active: true, currentWindow: true });

    chrome.scripting.executeScript(
        {
            target: { tabId: tab.id },
            func: calculateWBArchive
        },
        (results) => {
            document.getElementById("output").innerHTML = results[0].result;
        }
    );
});

function calculateWBArchive() {

    function parseArchive() {
        let items = document.querySelectorAll(".archive-page__item");
        let stats = {};

        const monthNames = [
            "январь", "февраль", "март", "апрель", "май", "июнь",
            "июль", "август", "сентябрь", "октябрь", "ноябрь", "декабрь"
        ];

        const currentYear = new Date().getFullYear();

        items.forEach(item => {
            let dateEl = item.querySelector(".archive-item__receive-date span:nth-of-type(2)");
            if (!dateEl) return;

            let dateText = dateEl.textContent.trim();
            let date;

            // Формат без года: "24 января"
            if (!/\d{4}/.test(dateText)) {
                let [d, monthName] = dateText.split(" ");
                let months = {
                    "января": 0, "февраля": 1, "марта": 2, "апреля": 3,
                    "мая": 4, "июня": 5, "июля": 6, "августа": 7,
                    "сентября": 8, "октября": 9, "ноября": 10, "декабря": 11
                };
                date = new Date(currentYear, months[monthName], +d);
            }
            else if (dateText.includes(".")) {
                let [d, m, y] = dateText.split(".");
                date = new Date(+y, +m - 1, +d);
            } else {
                let months = {
                    "января": 0, "февраля": 1, "марта": 2, "апреля": 3,
                    "мая": 4, "июня": 5, "июля": 6, "августа": 7,
                    "сентября": 8, "октября": 9, "ноября": 10, "декабря": 11
                };
                let [d, monthName, y] = dateText.split(" ");
                date = new Date(+y, months[monthName], +d);
            }

            let year = date.getFullYear();
            let month = date.getMonth();

            let priceEl = item.querySelector(".archive-item__price");
            if (!priceEl) return;

            let price = parseFloat(priceEl.textContent.replace("р.", "").replace(",", "."));
            if (isNaN(price)) return;

            if (!stats[year]) stats[year] = {};
            if (!stats[year][month]) stats[year][month] = 0;

            stats[year][month] += price;
        });

        return stats;
    }

    let stats = parseArchive();
    let years = Object.keys(stats).map(Number).sort((a, b) => b - a);

    const monthNames = [
        "январь", "февраль", "март", "апрель", "май", "июнь",
        "июль", "август", "сентябрь", "октябрь", "ноябрь", "декабрь"
    ];

    let html = "";

    years.forEach(year => {
        html += `<div class="year-block">`;
        html += `<div class="year-title">${year}</div>`;

        let yearTotal = 0;

        Object.keys(stats[year])
            .map(Number)
            .sort((a, b) => a - b)
            .forEach(month => {
                let sum = stats[year][month];
                yearTotal += sum;

                html += `
                    <div class="month-row">
                        <span>${monthNames[month]}</span>
                        <span>${sum.toFixed(2)} р.</span>
                    </div>
                `;
            });

        html += `<div class="total">Итого: ${yearTotal.toFixed(2)} р.</div>`;
        html += `</div>`;
    });

    return html || "<p>Не найдено товаров на странице.</p>";
}
